/**
 * 
 */
package gov.va.med.mhv.admin.enums;



/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public enum Gender {

    Male("M", "Male"), 
    Female("F", "Female");

    public static boolean isMale(String value) {
        return equals(Male, value);
    }
    public static boolean isFemale(String value) {
        return equals(Female, value);
    }
    public static boolean equals(Gender gender, String value) {
        return (gender != null) && 
            (gender.value.equalsIgnoreCase(value)
            || gender.name.equalsIgnoreCase(value));
    }

    public static Gender find(String value) {
        return (isMale(value)) ? Male : ((isFemale(value)) ? Female : null); 
    }

    private final String value;
    private final String name;
    
    private Gender(String value, String name) {
        this.value = value;
        this.name = name;
    }
    
    public String getValue() {
        return value;
    }

    public String getName() {
        return name;
    }


}
